jQuery(function ($) {
    // ✅ FIX: Initialize price range slider only if ionRangeSlider is available
    if (typeof $.fn.ionRangeSlider !== 'undefined') {
        $(".bc_filter .g-filter-item").each(function () {
            $(this)
                .find(".bc-filter-price")
                .each(function () {
                    var input_price = $(this).find(".filter-price");
                    if (input_price.length === 0) return;

                    // ✅ FIX: Check if already initialized
                    if (input_price.data('ionRangeSlider')) {
                        return; // Already initialized
                    }

                    var min = input_price.data("min") || 0;
                    var max = input_price.data("max") || 1000;
                    var from = input_price.data("from") || min;
                    var to = input_price.data("to") || max;
                    var symbol = input_price.data("symbol") || '';

                    input_price.ionRangeSlider({
                        type: "double",
                        grid: true,
                        min: min,
                        max: max,
                        from: from,
                        to: to,
                        prefix: symbol,
                    });
                });
        });
    }

    // ✅ FIX: Handle filter form submission
    $(".bc_form_filter input[type=checkbox]").change(function () {
        var form = $(this).closest(".bc_form_filter");
        if (form.length) {
            form.submit();
        }
    });
});
