(function ($) {
    var hotelRoomForm = new Vue({
        el:'#hotel-rooms',
        data:{
            id:'',
            extra_price:[],
            person_types:[
                [

                ]
            ],
            buyer_fees:[],
            message:{
                content:'',
                type:false
            },
            html:'',
            onSubmit:false,
            start_date:'',
            end_date:'',
            start_date_html:'',
            number_of_guests:0,
            step:1,
            start_date_obj:'',
            adults:1,
            children:0,
            children_ages:[], // ✅ NEW: Children ages array
            max_adults:20, // ✅ NEW: Maximum adults
            max_children:20, // ✅ NEW: Maximum children
            min_adults:1, // ✅ NEW: Minimum adults
            min_children:0, // ✅ NEW: Minimum children
            allEvents:[],
            rooms:[],
            onLoadAvailability:false,
            firstLoad:true,
            i18n:[],
            total_price_before_fee:0,
            total_price_fee:0,

            is_form_enquiry_and_book:false,
            enquiry_type:'book',
            enquiry_is_submit:false,
            enquiry_name:"",
            enquiry_email:"",
            enquiry_phone:"",
            enquiry_note:"",
        },
        watch:{
            extra_price:{
                handler:function f() {
                    this.step = 1;
                    // this.handleTotalPrice();
                },
                deep:true
            },
            start_date(){
                this.step = 1;
            },
            guests(){
                this.step = 1;
            },
            person_types:{
                handler:function f() {
                    this.step = 1;
                },
                deep:true
            },
            // ✅ NEW: Watch adults changes
            adults: {
                handler: function(newVal, oldVal) {
                    var me = this;
                    // ✅ Validate adults count
                    if (newVal < me.min_adults) {
                        me.$set(me, 'adults', me.min_adults);
                        return;
                    } else if (newVal > me.max_adults) {
                        me.$set(me, 'adults', me.max_adults);
                        return;
                    }
                    // ✅ Reset step when adults change
                    me.step = 1;
                    // ✅ Trigger availability check if dates are set
                    if (me.start_date && me.end_date) {
                        me.checkAvailability();
                    }
                },
                immediate: false
            },
            // ✅ NEW: Watch children changes
            children: {
                handler: function(newVal, oldVal) {
                    var me = this;
                    // ✅ Validate children count
                    if (newVal < me.min_children) {
                        me.$set(me, 'children', me.min_children);
                        return;
                    } else if (newVal > me.max_children) {
                        me.$set(me, 'children', me.max_children);
                        return;
                    }

                    // ✅ Update children_ages array
                    var diff = newVal - (oldVal || 0);
                    if (diff > 0) {
                        // Add new children with default age (5)
                        for (var i = 0; i < diff; i++) {
                            me.children_ages.push(5);
                        }
                    } else if (diff < 0) {
                        // Remove last children
                        for (var i = 0; i < Math.abs(diff); i++) {
                            me.children_ages.pop();
                        }
                    }

                    // ✅ Ensure children_ages length matches children count
                    while (me.children_ages.length < me.children) {
                        me.children_ages.push(5);
                    }
                    if (me.children_ages.length > me.children) {
                        me.children_ages = me.children_ages.slice(0, me.children);
                    }

                    // ✅ Reset step when children change
                    me.step = 1;
                    // ✅ Trigger availability check if dates are set
                    if (me.start_date && me.end_date) {
                        me.checkAvailability();
                    }
                },
                immediate: false
            },
            // ✅ NEW: Watch children_ages changes
            children_ages: {
                handler: function(newVal, oldVal) {
                    var me = this;
                    // ✅ Ensure children_ages length matches children count
                    if (newVal.length !== me.children) {
                        if (newVal.length < me.children) {
                            // Add missing ages
                            for (var i = newVal.length; i < me.children; i++) {
                                me.$set(me.children_ages, i, 5);
                            }
                        } else {
                            // Remove extra ages
                            me.children_ages = newVal.slice(0, me.children);
                        }
                    }
                    // ✅ Reset step when ages change
                    me.step = 1;
                    // ✅ Trigger availability check if dates are set
                    if (me.start_date && me.end_date) {
                        me.checkAvailability();
                    }
                },
                deep: true
            },
        },
        computed:{
            total_price:function(){
                var me = this;
                if (me.start_date !== "" && me.total_rooms > 0) {
                    var guests = me.children + me.adults;
                    var total_price = 0;
                    var startDate = new Date(me.start_date).getTime();
                    var endDate = new Date(me.end_date).getTime();
                    this.rooms.forEach(function (item) {
                        if(item.number_selected){
                            total_price += item.price* parseInt(item.number_selected);
                        }
                    });

                    var duration_in_day = moment(endDate).diff(moment(startDate), 'days');
                    for (var ix in me.extra_price) {
                        var item = me.extra_price[ix];
                        if(!item.price) continue;
                        var type_total = 0;
                        if (item.enable == 1) {
                            switch (item.type) {
                                case "one_time":
                                    type_total += parseFloat(item.price);
                                    break;
                                case "per_day":
                                    type_total += parseFloat(item.price) * Math.max(1,duration_in_day);
                                    break;
                            }
                            if (typeof item.per_person !== "undefined") {
                                type_total = type_total * guests;
                            }
                            total_price += type_total;
                        }
                    }
                    this.total_price_before_fee = total_price;

                    var total_fee = 0;
                    for (var ix in me.buyer_fees) {
                        var item = me.buyer_fees[ix];

                        if(!item.price) continue;

                        //for Fixed
                        var fee_price = parseFloat(item.price);

                        //for Percent
                        if (typeof item.unit !== "undefined" && item.unit === "percent" ) {
                            fee_price = ( total_price / 100 ) * fee_price;
                        }

                        if (typeof item.per_person !== "undefined") {
                            fee_price = fee_price * guests;
                        }
                        total_fee += fee_price;
                    }
                    total_price += total_fee;
                    this.total_price_fee = total_fee;

                    return total_price;
                }
                return 0;
            },
            total_rooms:function(){
                var me = this;
                if (me.start_date !== "") {
                    var t = 0;
                    this.rooms.forEach(function (item) {
                        if(item.number_selected){
                            t += parseInt(item.number_selected);
                        }
                    })
                    return t;
                }
                return 0;
            },
            total_price_html:function(){
                if(!this.total_price) return '';
                setTimeout(function () {
                    $('[data-toggle="tooltip"]').tooltip();
                    $(document).trigger("scroll");
                },200);
                return window.bc_format_money(this.total_price);
            },
            pay_now_price:function(){
                if(this.is_deposit_ready){
                    var total_price_depossit = 0;

                    var tmp_total_price = this.total_price;
                    var deposit_fomular = this.deposit_fomular;
                    if(deposit_fomular === "deposit_and_fee"){
                        tmp_total_price = this.total_price_before_fee;
                    }

                    switch (this.deposit_type) {
                        case "percent":
                            total_price_depossit =  tmp_total_price * this.deposit_amount / 100;
                            break;
                        default:
                            total_price_depossit =  this.deposit_amount;
                    }
                    if(deposit_fomular === "deposit_and_fee"){
                        total_price_depossit = total_price_depossit + this.total_price_fee;
                    }

                    return  total_price_depossit
                }
                return this.total_price;
            },
            pay_now_price_html:function(){
                return window.bc_format_money(this.pay_now_price);
            },
            is_deposit_ready:function () {
                if(this.deposit && this.deposit_amount) return true;
                return false;
            },
            daysOfWeekDisabled(){
                var res = [];

                for(var k in this.open_hours)
                {
                    if(typeof this.open_hours[k].enable == 'undefined' || this.open_hours[k].enable !=1 ){

                        if(k == 7){
                            res.push(0);
                        }else{
                            res.push(k);
                        }
                    }
                }

                return res;
            },
            guests(){
                return this.children + this.adults;
            },
            // ✅ NEW: Age options for children
            ageOptions: function() {
                var options = [];
                for (var i = 0; i <= 17; i++) {
                    options.push(i);
                }
                return options;
            },
            // ✅ NEW: Total guests
            totalGuests: function() {
                return this.adults + this.children;
            },
            // ✅ NEW: Can add more adults
            canAddAdults: function() {
                return this.adults < this.max_adults;
            },
            // ✅ NEW: Can add more children
            canAddChildren: function() {
                return this.children < this.max_children;
            },
            // ✅ NEW: Can remove adults
            canRemoveAdults: function() {
                return this.adults > this.min_adults;
            },
            // ✅ NEW: Can remove children
            canRemoveChildren: function() {
                return this.children > this.min_children;
            }
        },
        created:function(){
            var me = this;
            for(var k in bc_booking_data){
                this[k] = bc_booking_data[k];
            }

            // ✅ FIX: Read dates from URL if not in bc_booking_data
            if (!this.start_date || !this.end_date) {
                var urlParams = new URLSearchParams(window.location.search);
                var urlStartDate = urlParams.get('start_date');
                var urlEndDate = urlParams.get('end_date');

                // Fallback to legacy start/end
                if (!urlStartDate) urlStartDate = urlParams.get('start');
                if (!urlEndDate) urlEndDate = urlParams.get('end');

                if (urlStartDate) {
                    this.start_date = urlStartDate;
                }
                if (urlEndDate) {
                    this.end_date = urlEndDate;
                }
            }

            // ✅ FIX: Always update start_date_html if dates are available
            if (this.start_date && this.end_date) {
                var startMoment = moment(this.start_date, 'YYYY-MM-DD');
                var endMoment = moment(this.end_date, 'YYYY-MM-DD');
                if (startMoment.isValid() && endMoment.isValid()) {
                    var dateFormat = (typeof bookingCore !== 'undefined' && bookingCore.date_format)
                        ? bookingCore.date_format
                        : 'YYYY-MM-DD';
                    this.start_date_html = startMoment.format(dateFormat) +
                        ' <i class="fa fa-long-arrow-right" style="font-size: inherit"></i> ' +
                        endMoment.format(dateFormat);
                }
            }

            // ✅ NEW: Initialize children_ages from URL or bc_booking_data
            if (!this.children_ages || this.children_ages.length === 0) {
                // Try to get from URL
                var urlParams = new URLSearchParams(window.location.search);
                var childAgesParam = urlParams.get('child_ages') || urlParams.get('children_ages');

                if (childAgesParam) {
                    this.children_ages = childAgesParam.split(',').map(function(age) {
                        var ageInt = parseInt(age);
                        return (isNaN(ageInt) || ageInt < 0 || ageInt > 17) ? 5 : ageInt;
                    });
                } else if (typeof bc_booking_data !== 'undefined' && bc_booking_data) {
                    // Try to get from bc_booking_data
                    if (bc_booking_data.child_ages) {
                        if (Array.isArray(bc_booking_data.child_ages)) {
                            this.children_ages = bc_booking_data.child_ages.map(function(age) {
                                var ageInt = parseInt(age);
                                return (isNaN(ageInt) || ageInt < 0 || ageInt > 17) ? 5 : ageInt;
                            });
                        } else if (typeof bc_booking_data.child_ages === 'string') {
                            this.children_ages = bc_booking_data.child_ages.split(',').map(function(age) {
                                var ageInt = parseInt(age);
                                return (isNaN(ageInt) || ageInt < 0 || ageInt > 17) ? 5 : ageInt;
                            });
                        }
                    } else if (bc_booking_data.children_ages) {
                        if (Array.isArray(bc_booking_data.children_ages)) {
                            this.children_ages = bc_booking_data.children_ages.map(function(age) {
                                var ageInt = parseInt(age);
                                return (isNaN(ageInt) || ageInt < 0 || ageInt > 17) ? 5 : ageInt;
                            });
                        } else if (typeof bc_booking_data.children_ages === 'string') {
                            this.children_ages = bc_booking_data.children_ages.split(',').map(function(age) {
                                var ageInt = parseInt(age);
                                return (isNaN(ageInt) || ageInt < 0 || ageInt > 17) ? 5 : ageInt;
                            });
                        }
                    }
                }
            }

            // ✅ Ensure children_ages length matches children count
            while (this.children_ages.length < this.children) {
                this.children_ages.push(5);
            }
            if (this.children_ages.length > this.children) {
                this.children_ages = this.children_ages.slice(0, this.children);
            }

            // ✅ FIX: Wait for mounted() to complete before checking availability
            // This ensures daterangepicker is initialized and dates are set properly
            // Don't call checkAvailability() here - let hotel-rooms-enhanced.blade.php handle it
        },
        mounted(){
            var me = this;
            /*$(".hotel_room_book_status").sticky({
                topSpacing:30,
                bottomSpacing:$(document).height() - $('.end_tour_sticky').offset().top + 40
            });*/


            var options = {
                // singleDatePicker: true,
				maxSpan: {
					"days": 30
				},
                showCalendar: false,
                sameDate: true,
                autoApply           : true,
                disabledPast        : true,
                dateFormat          : bookingCore.date_format,
                enableLoading       : true,
                showEventTooltip    : true,
                classNotAvailable   : ['disabled', 'off'],
                disableHightLight: true,
                minDate:this.minDate,
                opens: bookingCore.rtl ? 'left':'right',
                locale:{
                    direction: bookingCore.rtl ? 'rtl':'ltr',
                    firstDay:daterangepickerLocale.first_day_of_week
                },
                isInvalidDate:function (date) {
                    for(var k = 0 ; k < me.allEvents.length ; k++){
                        var item = me.allEvents[k];
                        if(item.start == date.format('YYYY-MM-DD')){
                            return item.active ? false : true;
                        }
                    }
                    return false;
                },
                addClassCustom:function (date) {
                    for(var k = 0 ; k < me.allEvents.length ; k++){
                        var item = me.allEvents[k];
                        if(item.start == date.format('YYYY-MM-DD') && item.classNames !== undefined){
                            var class_names = "";
                            for(var i = 0 ; i < item.classNames.length ; i++){
                                var classItem = item.classNames[i];
                                class_names += " "+classItem;
                            }
                            return class_names;
                        }
                    }
                    return "";
                }
            };

            if (typeof  daterangepickerLocale == 'object') {
                options.locale = _merge(daterangepickerLocale, options.locale);
            }

            this.$nextTick(function () {
                // ✅ FIX: Set initial dates if available
                if (me.start_date && me.end_date) {
                    var startMoment = moment(me.start_date, 'YYYY-MM-DD');
                    var endMoment = moment(me.end_date, 'YYYY-MM-DD');
                    if (startMoment.isValid() && endMoment.isValid()) {
                        options.startDate = startMoment;
                        options.endDate = endMoment;
                    }
                }

                $(this.$refs.start_date).daterangepicker(options).on('apply.daterangepicker',
                    function (ev, picker) {
                        if(picker.endDate.diff(picker.startDate,'day') <=0){
							picker.endDate.add(1,'day');
                        }
                        me.start_date = picker.startDate.format('YYYY-MM-DD');
                        me.end_date = picker.endDate.format('YYYY-MM-DD');
                        me.start_date_html = picker.startDate.format(bookingCore.date_format) +' <i class="fa fa-long-arrow-right" style="font-size: inherit"></i> '+ picker.endDate.format(bookingCore.date_format);
                        // Trigger availability check when dates change
                        if (me.start_date && me.end_date) {
                            me.checkAvailability();
                        }
                    })

                // ✅ FIX: Set initial display if dates are available
                if (me.start_date && me.end_date) {
                    var picker = $(this.$refs.start_date).data('daterangepicker');
                    if (picker) {
                        var startMoment = moment(me.start_date, 'YYYY-MM-DD');
                        var endMoment = moment(me.end_date, 'YYYY-MM-DD');
                        if (startMoment.isValid() && endMoment.isValid()) {
                            picker.setStartDate(startMoment);
                            picker.setEndDate(endMoment);
                        }
                    }
                }
            })
        },
        methods:{
            handleTotalPrice:function() {
            },
            formatMoney: function (m) {
                return window.bc_format_money(m);
            },
            validate(){
                if(!this.start_date || !this.end_date)
                {
					this.message.status = false;
                    this.message.content = bc_booking_i18n.no_date_select;
                    return false;
                }
                if(!this.guests )
                {
					this.message.status = false;
                    this.message.content = bc_booking_i18n.no_guest_select;
                    return false;
                }

                return true;
            },
            addPersonType: function(type) {
                var me = this;
                switch (type) {
                    case "adults":
                        if (me.adults < me.max_adults) {
                            me.$set(me, 'adults', me.adults + 1);
                        }
                        break;
                    case "children":
                        if (me.children < me.max_children) {
                            me.$set(me, 'children', me.children + 1);
                        }
                        break;
                }
            },
            minusPersonType: function(type) {
                var me = this;
                switch (type) {
                    case "adults":
                        if (me.adults > me.min_adults) {
                            me.$set(me, 'adults', me.adults - 1);
                        }
                        break;
                    case "children":
                        if (me.children > me.min_children) {
                            me.$set(me, 'children', me.children - 1);
                        }
                        break;
                }
            },
            // ✅ NEW: Update child age
            updateChildAge: function(index, age) {
                var me = this;
                var ageInt = parseInt(age);
                if (isNaN(ageInt) || ageInt < 0 || ageInt > 17) {
                    ageInt = 5; // Default age
                }
                me.$set(me.children_ages, index, ageInt);
            },
            // ✅ NEW: Get child age
            getChildAge: function(index) {
                return this.children_ages[index] || 5;
            },
            // ✅ NEW: Validate children input
            validateChildren: function() {
                var me = this;
                if (me.children < me.min_children) {
                    me.$set(me, 'children', me.min_children);
                } else if (me.children > me.max_children) {
                    me.$set(me, 'children', me.max_children);
                }
            },
            // ✅ NEW: Validate adults input
            validateAdults: function() {
                var me = this;
                if (me.adults < me.min_adults) {
                    me.$set(me, 'adults', me.min_adults);
                } else if (me.adults > me.max_adults) {
                    me.$set(me, 'adults', me.max_adults);
                }
            },
			checkAvailability:function () {
                var me  = this;
                if(!this.firstLoad){
                    if(!this.start_date || !this.end_date){
                        bookingCoreApp.showError(this.i18n.date_required);
                        return;
                    }
                }

                // ✅ FIX: Don't check if dates are missing (even on first load)
                if(!this.start_date || !this.end_date){
                    return;
                }

                // ✅ FIX: Reset rooms array before loading
                me.$set(me, 'rooms', []);
                me.onLoadAvailability = true;

                $.ajax({
                    url:bookingCore.module.hotel+'/checkAvailability',
                    data:{
                        hotel_id:this.id,
                        start_date:this.start_date,
                        end_date:this.end_date,
						firstLoad:me.firstLoad,
                        adults:this.adults,
                        children:this.children,
                        // ✅ NEW: Add children_ages
                        child_ages: this.children_ages.length > 0
                            ? this.children_ages.join(',')
                            : '',
                        children_ages: this.children_ages, // ✅ Also send as array
                    },
                    method:'post',
                    dataType:'json',
                    success:function (json) {
                        console.log('✅ checkAvailability Success:', json); // ✅ DEBUG
                        console.log('✅ Response structure:', {
                            'has_rooms': !!(json && json.rooms),
                            'rooms_type': json && json.rooms ? typeof json.rooms : 'N/A',
                            'is_array': json && json.rooms ? Array.isArray(json.rooms) : false,
                            'rooms_count': json && json.rooms && Array.isArray(json.rooms) ? json.rooms.length : 0,
                            'status': json ? json.status : 'N/A',
                            'full_response_keys': json ? Object.keys(json) : []
                        }); // ✅ DEBUG

                        // ✅ FIX: Keep onLoadAvailability true until rooms are set
                        // We'll set it to false after rooms are updated
                        me.firstLoad = false;

                        // ✅ FIX: Handle response structure correctly
                        // Response format: {status: 1, rooms: [...], policies: {...}, validation: {...}}
                        var roomsData = null;

                        // Check if response has rooms directly
                        if(json && json.rooms && Array.isArray(json.rooms)){
                            roomsData = json.rooms;
                        }
                        // Check if response has data.rooms (nested structure)
                        else if(json && json.data && json.data.rooms && Array.isArray(json.data.rooms)){
                            roomsData = json.data.rooms;
                        }
                        // Check if response itself is an array (unlikely but possible)
                        else if(Array.isArray(json)){
                            roomsData = json;
                        }

                        if(roomsData && roomsData.length > 0){
                            console.log('✅ Setting rooms:', roomsData.length, 'rooms'); // ✅ DEBUG
                            console.log('✅ First room sample:', roomsData[0]); // ✅ DEBUG

                            // ✅ CRITICAL FIX: Create a new array to ensure Vue reactivity
                            // Vue.js needs a new array reference to detect changes
                            var newRoomsArray = [];
                            roomsData.forEach(function(room, index){
                                // Create a new room object with all properties
                                var newRoom = Object.assign({}, room);
                                // Initialize number_selected if not exists
                                if(typeof newRoom.number_selected === 'undefined'){
                                    newRoom.number_selected = 0;
                                }
                                newRoomsArray.push(newRoom);
                            });

                            console.log('✅ New rooms array created:', newRoomsArray.length, 'rooms'); // ✅ DEBUG
                            console.log('✅ New rooms array sample:', newRoomsArray[0]); // ✅ DEBUG

                            // ✅ CRITICAL FIX: Use Vue.set with new array reference
                            me.$set(me, 'rooms', newRoomsArray);

                            // ✅ Force Vue to update immediately
                            me.$nextTick(function () {
                                console.log('✅ Vue updated, rooms count:', me.rooms.length); // ✅ DEBUG
                                console.log('✅ Vue rooms array:', me.rooms); // ✅ DEBUG
                                console.log('✅ onLoadAvailability:', me.onLoadAvailability); // ✅ DEBUG
                                console.log('✅ firstLoad:', me.firstLoad); // ✅ DEBUG

                                // ✅ Force re-render
                                me.$forceUpdate();

                                // ✅ Initialize JS after render
                                setTimeout(function() {
                                    me.initJs();
                                }, 100);
                            });
                        } else {
                            console.warn('⚠️ No rooms in response or invalid format:', {
                                'json': json,
                                'has_json': !!json,
                                'has_rooms': !!(json && json.rooms),
                                'rooms_type': json && json.rooms ? typeof json.rooms : 'N/A',
                                'is_array': json && json.rooms ? Array.isArray(json.rooms) : false
                            }); // ✅ DEBUG
                            // ✅ Set empty array if no rooms
                            me.$set(me, 'rooms', []);
                            // ✅ Set onLoadAvailability to false even if no rooms
                            me.onLoadAvailability = false;
                        }

                        if(json && json.message){
                            bookingCoreApp.showAjaxMessage(json);
                        }
                    },
                    error:function (e) {
                        console.error('❌ checkAvailability Error:', e); // ✅ DEBUG
                        me.onLoadAvailability = false; // ✅ FIX: Set onLoadAvailability to false on error
                        me.firstLoad = false;
                        // ✅ Set empty array on error
                        me.$set(me, 'rooms', []);
                        bookingCoreApp.showAjaxError(e);
                    }
                })
			},
            doSubmit:function (e) {
                e.preventDefault();
                if(this.onSubmit) return false;

                if(!this.validate()) return false;

                this.onSubmit = true;
                var me = this;

                this.message.content = '';

                if(this.step == 1){
                    this.html = '';
                }
                $.ajax({
                    url:bookingCore.url+'/booking/addToCart',
                    data:{
                        service_id:this.id,
                        service_type:"hotel",
                        start_date:this.start_date,
                        end_date:this.end_date,
                        extra_price:this.extra_price,
                        adults:this.adults,
                        children:this.children,
                        // ✅ NEW: Add children_ages
                        child_ages: this.children_ages.length > 0
                            ? this.children_ages.join(',')
                            : '',
                        children_ages: this.children_ages, // ✅ Also send as array
                        rooms:this.rooms.map(function (item) {
                            return objectPick(item,['id','number_selected'])
                        })
                    },
                    dataType:'json',
                    type:'post',
                    success:function(res){
                        if(!res.status){
                            me.onSubmit = false;
                        }
                        if(res.message){
                            bookingCoreApp.showAjaxMessage(res);
                        }
                        if(res.step){
                            me.step = res.step;
                        }
                        if(res.html){
                            me.html = res.html
                        }
                        if(res.url){
                            window.location.href = res.url
                        }
                        if(res.errors && typeof res.errors == 'object')
                        {
                            var html = '';
                            for(var i in res.errors){
                                html += res.errors[i]+'<br>';
                            }
                            me.message.content = html;
                            bookingCoreApp.showError(html);
                        }
                    },
                    error:function (e) {
                        console.log(e);
                        me.onSubmit = false;
                        bc_handle_error_response(e);
                        if(e.status == 401){
                            //$('.bc_single_book_wrap').modal('hide');
                        }
                        if(e.status != 401 && e.responseJSON){
                            me.message.content = e.responseJSON.message ? e.responseJSON.message : 'Can not booking';
                            me.message.type = false;

                        }
                    }
                })
            },
            doEnquirySubmit:function(e){
                e.preventDefault();
                if(this.onSubmit) return false;
                if(!this.validateenquiry()) return false;
                this.onSubmit = true;
                var me = this;
                this.message.content = '';
                $.ajax({
                    url:bookingCore.url+'/booking/addEnquiry',
                    data:{
                        service_id:this.id,
                        service_type:'hotel',
                        name:this.enquiry_name,
                        email:this.enquiry_email,
                        phone:this.enquiry_phone,
                        note:this.enquiry_note,
                    },
                    dataType:'json',
                    type:'post',
                    success:function(res){
                        if(res.message)
                        {
                            me.message.content = res.message;
                            me.message.type = res.status;
                        }
                        if(res.errors && typeof res.errors == 'object')
                        {
                            var html = '';
                            for(var i in res.errors){
                                html += res.errors[i]+'<br>';
                            }
                            me.message.content = html;
                        }
                        if(res.status){
                            me.enquiry_is_submit = true;
                            me.enquiry_name = "";
                            me.enquiry_email = "";
                            me.enquiry_phone = "";
                            me.enquiry_note = "";
                        }
                        me.onSubmit = false;
                    },
                    error:function (e) {
                        me.onSubmit = false;
                        bc_handle_error_response(e);
                        if(e.status == 401){
                            $('.bc_single_book_wrap').modal('hide');
                        }
                        if(e.status != 401 && e.responseJSON){
                            me.message.content = e.responseJSON.message ? e.responseJSON.message : 'Can not booking';
                            me.message.type = false;
                        }
                    }
                })
            },
            validateenquiry(){
                if(!this.enquiry_name)
                {
                    this.message.status = false;
                    this.message.content = bc_booking_i18n.name_required;
                    return false;
                }
                if(!this.enquiry_email)
                {
                    this.message.status = false;
                    this.message.content = bc_booking_i18n.email_required;
                    return false;
                }
                return true;
            },
            openStartDate:function(){
                $(this.$refs.start_date).trigger('click');
            },
            initJs:function () {
                //$('.fotorama').fotorama();
            },
            showGallery:function(e,id,gallery)
            {
                if(gallery !== null){
                    var p  = $(e.target).closest('.row');
                    $('#modal_room_'+id).modal().modal('show');
                    p.find('.fotorama').each(function () {
                        $(this).fotorama();
                    });
                }
            }
        }

    });
    $(window).on("load", function () {
        var urlHash = window.location.href.split("#")[1];
        if (urlHash &&  $('.' + urlHash).length ){
            var offset_other = 70
            if(urlHash === "review-list"){
                offset_other = 330;
            }
            $('html,body').animate({
                scrollTop: $('.' + urlHash).offset().top - offset_other
            }, 1000);
        }
        $(document).find('[data-toggle=tooltip]').tooltip();
    });
    $(".bc-button-book-mobile").click(function () {
        //$('.bc_single_book_wrap').modal('show');

    });

    $(".bc_detail_space .g-faq .item .header").click(function () {
        $(this).parent().toggleClass("active");
    });

    $(".btn-show-all").click(function () {
        $(this).parent().find(".d-none").removeClass("d-none");
        $(this).addClass("d-none");
    });

    $(".start_room_sticky").each(function () {
        var $this_list_room = $(this).closest(".hotel_rooms_form");
        $(window).scroll(function() {
            var window_height = $(window).height();
            var windowTop = $(window).scrollTop();
            var stickyTop = $('.start_room_sticky').offset().top + 100 - window_height;
            var stickyBottom =  stickyTop + $this_list_room.height() - 300;
            if (stickyTop < windowTop && windowTop < stickyBottom) {
                $(document).find(".hotel_room_book_status").addClass("sticky").css("width",$this_list_room.width());
                $(document).find(".end_room_sticky").css("min-height",$(document).find(".hotel_room_book_status").height() + 32 + 20);

                setTimeout(function () {
                    $(document).find(".hotel_room_book_status").addClass("active");
                },100);
            } else {
                $(document).find(".hotel_room_book_status").removeClass("sticky").css("width","auto");
                $(document).find(".end_room_sticky").css("min-height","auto");
                $(document).find(".hotel_room_book_status").removeClass("active");
            }
        });
    });

})(jQuery);
